% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/methods-vclVector.R
\docType{methods}
\name{as.vclVector}
\alias{as.vclVector}
\alias{as.vclVector,vector-method}
\alias{as.vclVector,vector}
\alias{as.vclVector,vclMatrix-method}
\alias{as.vclVector,vclMatrix}
\title{Convert object to a vclVector}
\usage{
as.vclVector(object, type, ...)

\S4method{as.vclVector}{vector}(object, type = NULL)

\S4method{as.vclVector}{vclMatrix}(object, shared, type = NULL)
}
\arguments{
\item{object}{An object that is or can be converted to a 
\code{vector} object}

\item{type}{A character string specifying the type of vclVector.  Default
is NULL where type is inherited from the source data type.}

\item{...}{Additional arguments to as.vclVector methods}

\item{shared}{Logical indicating if memory should be shared with \code{x}}
}
\value{
A vclVector object
}
\description{
Construct a vclVector of a class that inherits
from \code{vclVector}

#' @rdname as.vclVector-methods
#' @param shared Logical indicating if memory should be shared with \code{x}
#' @export
as.vclVector <- function (data, shared, ...) {
    UseMethod("as.vclVector", data)
}
}
\author{
Charles Determan Jr.
}
