% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpuMatrix.R
\docType{methods}
\name{gpuMatrix}
\alias{gpuMatrix}
\alias{gpuMatrix,matrix-method}
\alias{gpuMatrix,matrix}
\alias{gpuMatrix,missing-method}
\alias{gpuMatrix,missing}
\alias{gpuMatrix,numeric-method}
\alias{gpuMatrix,numeric}
\alias{gpuMatrix,integer-method}
\alias{gpuMatrix,integer}
\title{Construct a gpuMatrix}
\usage{
gpuMatrix(data = NA, nrow = NA, ncol = NA, type = NULL, ...)

\S4method{gpuMatrix}{matrix}(data, type = NULL, ctx_id = NULL)

\S4method{gpuMatrix}{missing}(data, nrow = NA, ncol = NA, type = NULL,
  ctx_id = NULL)

\S4method{gpuMatrix}{numeric}(data, nrow, ncol, type = NULL, ctx_id = NULL)

\S4method{gpuMatrix}{integer}(data, nrow, ncol, type = NULL, ctx_id = NULL)
}
\arguments{
\item{data}{An object that is or can be converted to a 
\code{matrix} object}

\item{nrow}{An integer specifying the number of rows}

\item{ncol}{An integer specifying the number of columns}

\item{type}{A character string specifying the type of gpuMatrix.  Default
is NULL where type is inherited from the source data type.}

\item{...}{Additional method to pass to gpuMatrix methods}

\item{ctx_id}{An integer specifying the object's context}
}
\value{
A gpuMatrix object
}
\description{
Construct a gpuMatrix of a class that inherits
from \code{gpuMatrix}
}
\author{
Charles Determan Jr.
}
