% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_x_reorder.R
\name{table_x_reorder}
\alias{table_x_reorder}
\title{Reordering groups along X-axis}
\usage{
table_x_reorder(data, xcol, OrderX, ...)
}
\arguments{
\item{data}{a data table or tibble.}

\item{xcol}{name of column in above data table (in quotes), e.g., "A", whose levels are to be reordered.}

\item{OrderX}{a vector of group names within the column selected in \code{xcol} in the desired order, .e.g., c("D", "A", "C").}

\item{...}{any additional arguments for \code{factor} call.}
}
\value{
This function returns a data frame with a selected column converted into factor with reordered levels.
}
\description{
This simple function takes in a data table and reorders groups (categorical variables or factors) to be plotted along the X-axis in a user-defined order.
}
\details{
It uses two base R functions: \code{as.factor} to first force the user-selected column into a factor, and \code{factor} that reorders levels based on a user-provided vector.
}
\examples{
#reorder levels within Genotype
new_data <- table_x_reorder(data_t_pratio, 
xcol = "Genotype", 
OrderX = c("KO", "WT"))
#compare 
plot_scatterbox(data_t_pratio, 
Genotype, 
Cytokine)
#with
plot_scatterbox(new_data, 
Genotype, 
Cytokine)
#also works within the plot call
plot_scatterbox(data = table_x_reorder(data_t_pratio, 
xcol = "Genotype", 
OrderX = c("KO", "WT")), 
xcol = Genotype, 
ycol = Cytokine)

}
