% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grantham_distance.R
\name{grantham_equation}
\alias{grantham_equation}
\title{Grantham distance}
\usage{
grantham_equation(
  c_i,
  c_j,
  p_i,
  p_j,
  v_i,
  v_j,
  alpha = 1.833,
  beta = 0.1018,
  gamma = 0.000399,
  rho = 50.723
)
}
\arguments{
\item{c_i}{composition value for the \emph{ith} amino acid.}

\item{c_j}{composition value for the \emph{jth} amino acid.}

\item{p_i}{polarity value for the \emph{ith} amino acid.}

\item{p_j}{polarity value for the \emph{jth} amino acid.}

\item{v_i}{molecular volume value for the \emph{ith} amino acid.}

\item{v_j}{molecular volume value for the \emph{jth} amino acid.}

\item{alpha}{The constant \eqn{\alpha} in the equation of Grantham's
paper, in page 863.}

\item{beta}{The constant \eqn{\beta} in the equation of Grantham's
paper, in page 863.}

\item{gamma}{The constant \eqn{\gamma} in the equation of Grantham's
paper, in page 863.}

\item{rho}{Grantham's distances reported in Table 2, Science (1974).
185(4154): 862--4 by R. Grantham, are scaled by a factor (here named
\eqn{\rho}) such that the mean value of all distances are 100. The \code{rho}
parameter allows this factor \eqn{\rho} to be changed. By default
\eqn{\rho=50.723}, the same value used by Grantham. This value is
originally mentioned in the caption of Table 2 of the aforementioned paper.}
}
\value{
A double vector of Grantham's distances.
}
\description{
This function calculates Grantham's distance \eqn{d_{i,j}} between two
amino acids (\eqn{i} and \eqn{j}) based on their chemical properties:

\deqn{d_{i,j} = \rho ((\alpha (c_i-c_j)^2 + \beta (p_i-p_j)^2 + \gamma (v_i-v_j)^2)^\frac{1}{2}}

This calculation is based on three amino acid side chain properties that were
found to be the three strongest correlators with the relative substitution
frequency (RSF) (references cited in Grantham (1974)), namely:
\itemize{
\item composition \eqn{c}, meaning the atomic weight ratio of hetero (noncarbon)
elements in end groups or rings to carbons in the side chain.
\item polarity \eqn{p};
\item molecular volume \eqn{v}.
}

Each property difference is weighted by dividing by the mean distance found
with it alone in the formula. The constants \eqn{\alpha}, \eqn{\beta} and
\eqn{\gamma} are squares of the inverses of mean distances of each property,
respectively.

The distances reported by Grantham (1972) are further scaled by a factor
---here coined \eqn{\rho}--- such that the mean of all distances is 100.
Although this factor is not explicitly included in Grantham's distance
formula, it is actually used for calculating the amino acid pair distances
reported in Table 2 of Grantham's paper. So, for all intents and purposes,
this factor should be regarded as part of the formula used to calculate
Grantham distance, and therefore we include it explicitly in the equation
above.

If you want to calculate Grantham's distance right off from the identity of
the amino acids, instead of using their chemical properties, then use
\code{\link[=grantham_distance]{grantham_distance()}}.
}
\seealso{
Check \link{amino_acids_properties} for a table of the three property
values that can be used with this formula. This data set is from Table 1,
Science (1974). 185(4154): 862--4 by R. Grantham.
}
