% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mat_geo_dist.R
\name{mat_geo_dist}
\alias{mat_geo_dist}
\title{Compute Euclidean geographic distances between points}
\usage{
mat_geo_dist(data, ID = NULL, x = NULL, y = NULL)
}
\arguments{
\item{data}{An object of class :\itemize{
\item \code{data.frame} with 3 columns: 2 columns with the points' spatial
coordinates and another column with points' IDs
\item \code{SpatialPointsDataFrame} }}

\item{ID}{(if \code{data} is of class \code{data.frame}) A character string
indicating the name of the column of \code{data} with the points' IDs}

\item{x}{(if \code{data} is of class \code{data.frame}) A character string
indicating the name of the column of \code{data} with the points' longitude}

\item{y}{(if \code{data} is of class \code{data.frame}) A character string
indicating the name of the column of \code{data} with the points' latitude}
}
\value{
A pairwise matrix of geographic distances between points
}
\description{
The function computes Euclidean geographic distance between
points given their coordinates in a metric projected Coordinates
Reference System.
}
\details{
Calculate classical Euclidean geographic distance (in m)
between two points using Pythagora's theorem
}
\examples{
data(pts_pop_simul)
mat_dist <- mat_geo_dist(data=pts_pop_simul,
             ID = "ID",
             x = "x",
             y = "y")
}
\author{
P. Savary
}
