% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitting_estimation_functions.R
\name{emp_chi_mat}
\alias{emp_chi_mat}
\title{Empirical estimation of extremal correlation matrix \eqn{\chi}}
\usage{
emp_chi_mat(data, p)
}
\arguments{
\item{data}{Numeric matrix of size \eqn{n\times d}{n x d}, where \eqn{n} is the
number of observations and \eqn{d} is the dimension.}

\item{p}{Numeric between 0 and 1. Probability used for the quantile to
compute the \eqn{\chi} coefficient.}
}
\value{
Numeric matrix \eqn{d\times d}{d x d}. The matrix contains the
bivariate extremal coefficients \eqn{\chi_{ij}}, for \eqn{i, j = 1, ..., d}.
}
\description{
Estimates empirically the matrix of bivariate extremal correlation coefficients \eqn{\chi}.
}
\examples{
n <- 100
d <- 4
p <- .8
Gamma <- cbind(c(0, 1.5, 1.5, 2),
               c(1.5, 0, 2, 1.5),
               c(1.5, 2, 0, 1.5),
               c(2, 1.5, 1.5, 0))

set.seed(123)
my_data = rmstable(n, "HR", d = d, par = Gamma)
emp_chi_mat(my_data, p)

}
