% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-methods.R
\name{draw.derivatives}
\alias{draw.derivatives}
\title{Plot derivatives of smooths}
\usage{
\method{draw}{derivatives}(object, select = NULL, scales = c("free",
  "fixed"), alpha = 0.2, align = "hv", axis = "lrtb", ...)
}
\arguments{
\item{object}{a fitted GAM, the result of a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{select}{character, logical, or numeric; which smooths to plot. If
\code{NULL}, the default, then all model smooths are drawn. Numeric \code{select}
indexes the smooths in the order they are specified in the formula and
stored in \code{object}. Character \code{select} matches the labels for smooths
as shown for example in the output from \code{summary(object)}. Logical
\code{select} operates as per numeric \code{select} in the order that smooths are
stored.}

\item{scales}{character; should all univariate smooths be plotted with the
same y-axis scale? The default, \code{scales = "fixed"}, ensures this is done.
If \code{scales = "free"} each univariate smooth has its own y-axis scale.
Currently does not affect the y-axis scale of plots of the parametric
terms.}

\item{alpha}{numeric; alpha transparency for confidence or simultaneous
interval.}

\item{align}{characer; see argument \code{align} in \code{cowplot::plot_grid()}.
Defaults to \code{"hv"} so that plots are nicely aligned.}

\item{axis}{characer; see argument \code{axis} in \code{cowplot::plot_grid()}.
Defaults to \code{"lrtb"} so that plots are nicely aligned.}

\item{...}{arguments passed to \code{cowplot::plot_grid()}. Any arguments to
\code{plot_grid()} may be supplied, except for: \code{plotlist} and \code{align}.}
}
\description{
Plot derivatives of smooths
}
\examples{

library("mgcv")
\dontshow{set.seed(42)}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2, verbose = FALSE)
mod <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = dat, method = "REML")

## first derivative of all smooths
df <- derivatives(mod)
draw(df)
}
