# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Threeway parallel maximum
#' @description Returns the parallel maximum of three 
#' 
#' @name pmax3
#' @param x,y,z Numeric vectors of identical lengths.
#' @return The parallel maximum of the vectors.
#' @export pmax3
NULL

pmax3 <- function(x, y, z) {
    .Call('grattan_pmax3', PACKAGE = 'grattan', x, y, z)
}

#' @title Parallel maximum
#' @description A faster \code{pmax()}.
#'
#' @name pmaxC
#' @param x A numeric vector.
#' @param a A single numeric value.
#' @return The parallel maximum of the input values.
#' @note This function will always be faster than \code{pmax(x, a)} when \code{a} is a single value, but can be slower than \code{pmax.int(x, a)} when \code{x} is short. Use this function when comparing a numeric vector with a single value.
#' @export pmaxC
NULL

pmaxC <- function(x, a) {
    .Call('grattan_pmaxC', PACKAGE = 'grattan', x, a)
}

#' @title Parallel maximum
#' @description A faster \code{pmax()}.
#'
#' @name pmaxV
#' @param x A numeric vector.
#' @param y A numeric vector, the same length as x.
#' @return The parallel maximum of the input values.
#' @export pmaxV
NULL

pmaxV <- function(x, y) {
    .Call('grattan_pmaxV', PACKAGE = 'grattan', x, y)
}

#' @title Parallel maximum
#' @description A faster \code{pmin()}.
#'
#' @name pminC
#' @param x A numeric vector.
#' @param a A single numeric value.
#' @return The parallel minimum of the input values.
#' @note This function will always be faster than \code{pmin(x, a)} when \code{a} is a single value, but can be slower than \code{pmin.int(x, a)} when \code{x} is short. Use this function when comparing a numeric vector with a single value.
#' @export pminC
NULL

pminC <- function(x, a) {
    .Call('grattan_pminC', PACKAGE = 'grattan', x, a)
}

#' @title Parallel maximum
#' @description A faster \code{pmin()}.
#'
#' @name pminV
#' @param x A numeric vector.
#' @param y A numeric vector, the same length as x.
#' @return The parallel maximum of the input values.
#' @export pminV
NULL

pminV <- function(x, y) {
    .Call('grattan_pminV', PACKAGE = 'grattan', x, y)
}

