% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_gran.R
\name{create_gran}
\alias{create_gran}
\title{Build dynamic temporal granularities}
\usage{
create_gran(.data, gran1 = NULL, hierarchy_tbl = NULL, label = TRUE,
  abbr = TRUE, ...)
}
\arguments{
\item{.data}{A tsibble object.}

\item{gran1}{the granularity to be created. For temporal data, any
combination of "second", "minute", "qhour", "hhour", "hour", "day", "week", "fortnight
,"month", "quarter", "semester" or "year" can be chosen in the form of finer #' to coarser unit. For example, for the granularity hour of the week, value is
"hour_week".}

\item{hierarchy_tbl}{A hierarchy table specifying the hierarchy of units and #' their relationships.}

\item{label}{Logical. TRUE will display the month as an ordered factor of
character string such as "January", "February". FALSE will display the month #' as an ordered factor such as 1 to 12, where 1 stands for January and 12 for
December.}

\item{abbr}{logical. FALSE will display abbreviated labels.}

\item{...}{Other arguments passed on to individual methods.}
}
\value{
A tsibble with an additional column of granularity.
}
\description{
Create time granularities that accommodate for periodicities in data, both single and multiple order up.
Periodic ones might include time granularities like minute of the day, hour
 of the week  and aperiodic calendar categorizations may include day of the month or
week of the quarter. For non-temporal data, supports
only periodic deconstructions.
}
\examples{
library(dplyr)
library(ggplot2)
library(lvplot)
# Search for granularities
smart_meter10 \%>\%
  search_gran(highest_unit = "week")

# Screen harmonies from the search list
\dontrun{
smart_meter10 \%>\%
  harmony(
    ugran = "day",
    filter_in = "wknd_wday"
  )
}
# visualize probability distribution of
# the harmony pair (wknd_wday, hour_day)
smart_meter10 \%>\%
filter(customer_id == 10017936) \%>\%
  prob_plot(
    gran1 = "wknd_wday",
    gran2 = "hour_day",
    response = "general_supply_kwh",
    plot_type = "quantile",
    quantile_prob = c(0.1, 0.25, 0.5, 0.75, 0.9)
  ) +
  scale_y_sqrt()

#' # Compute granularities for non-temporal data

library(tsibble)
cricket_tsibble <- cricket \%>\%
mutate(data_index = row_number()) \%>\%
as_tsibble(index = data_index)

hierarchy_model <- tibble::tibble(
  units = c("index", "over", "inning", "match"),
  convert_fct = c(1, 20, 2, 1)
)
cricket_tsibble \%>\%
  create_gran(
    "over_inning",
    hierarchy_model
  )

  cricket_tsibble \%>\%
  filter(batting_team \%in\% c("Mumbai Indians",
                             "Chennai Super Kings"))\%>\%
  prob_plot("inning", "over",
  hierarchy_model,
  response = "runs_per_over",
  plot_type = "lv")

# Validate if given column in the data set
# equals computed granularity
validate_gran(cricket_tsibble,
  gran = "over_inning",
  hierarchy_tbl = hierarchy_model,
  validate_col = "over"
)
}
