% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harmony.R
\name{harmony}
\alias{harmony}
\title{Get possible set of harmonies for a given tsibble}
\usage{
harmony(
  .data,
  ugran = "year",
  lgran = NULL,
  hierarchy_tbl = NULL,
  filter_in = NULL,
  filter_out = NULL,
  facet_h = NULL,
  ...
)
}
\arguments{
\item{.data}{A tsibble object.}

\item{ugran}{Typically set as the most coarse unit required in the analysis.
Default is "year".}

\item{lgran}{For "regular" tsibble, lgran is the interval of the tsibble.
It needs to be specified for "irregular" time intervals. Typically serves as the finest unit required for analysis.}

\item{hierarchy_tbl}{A hierarchy table specifying the hierarchy of units and
their relationships.}

\item{filter_in}{Choices of temporal units to be kept. Can be column names if #' required granularity already exists in the tsibble. For example, a column with public holidays which needs to be treated as granularity, can be included here for checking how it interacts with other granularities.}

\item{filter_out}{Choices of temporal units to be discarded.}

\item{facet_h}{highest level of facets allowed.}

\item{...}{added arguments to be passed.}
}
\value{
A tibble of harmonies and their levels.The levels can be used to
decide which granularities to be plotted across x-axis/facets for
exploratory aid.
}
\description{
Interaction of pair of granularities, categorised as harmony and clash. harmony () screens out harmony pairs from
list of all possible pairs of granularities.
}
\examples{
library(tsibbledata)
vic_elec \%>\% harmony(lgran = "hour", ugran = "week")
}
