% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BVW.R
\name{BVW}
\alias{BVW}
\title{Bonus vetus OLS, BVW}
\usage{
BVW(y, dist, x, inc_d, inc_o, vce_robust = TRUE, data, ...)
}
\arguments{
\item{y}{name (type: character) of the dependent variable in the dataset 
\code{data}, e.g. trade flows. This dependent variable is divided by the 
product of unilateral incomes (\code{inc_o} and \code{inc_d}, e.g. 
GDPs or GNPs of the countries of interest) and logged afterwards.
The transformed variable is then used as the dependent variable in the 
estimation.}

\item{dist}{name (type: character) of the distance variable in the dataset 
\code{data} containing a measure of distance between all pairs of bilateral
partners. It is logged automatically when the function is executed.}

\item{x}{vector of names (type: character) of those bilateral variables in 
the dataset \code{data} that should be taken as the independent variables 
in the estimation. If an independent variable is a dummy variable,
it should be of type numeric (0/1) in the dataset. If an independent variable 
is defined as a ratio, it should be logged. Unilateral metric variables 
such as GDPs should be inserted via the arguments \code{inc_o} 
for the country of origin and \code{inc_d} for the country of destination.
As country specific effects are subdued due to demeaning, no further
unilateral variables apart from \code{inc_o} and \code{inc_d} can be 
added.}

\item{inc_d}{variable name (type: character) of the income of the country of 
destination in the dataset \code{data}. The dependent variable \code{y} is
divided by the product of the incomes \code{inc_d} and \code{inc_o}.}

\item{inc_o}{variable name (type: character) of the income of the country of 
origin in the dataset \code{data}. The dependent variable \code{y} is
divided by the product of the incomes \code{inc_d} and \code{inc_o}.}

\item{vce_robust}{robust (type: logic) determines whether a robust 
variance-covariance matrix should be used. The default is set to \code{TRUE}. 
If set \code{TRUE} the estimation results equal the Stata results for 
robust estimation.}

\item{data}{name of the dataset to be used (type: character). 
To estimate gravity equations, a square gravity dataset including bilateral 
flows defined by the argument \code{y}, ISO-codes of type character 
(called \code{iso_o} for the country of origin and \code{iso_d} for the 
destination country), a distance measure defined by the argument \code{dist} 
and other potential influences given as a vector in \code{x} are required. 
All dummy variables should be of type numeric (0/1). Missing trade flows as 
well as incomplete rows should be excluded from the dataset. 
Furthermore, flows equal to zero should be excluded as the gravity equation 
is estimated in its additive form.
As, to our knowledge at the moment, there is no explicit literature covering 
the estimation of a gravity equation by \code{BVW} 
using panel data, cross-sectional data should be used.}

\item{...}{additional arguments to be passed to \code{BVW}.}
}
\value{
The function returns the summary of the estimated gravity model as an 
\code{lm}-object.
}
\description{
\code{BVW} estimates gravity models via Bonus 
vetus OLS with GDP-weights.
}
\details{
\code{Bonus vetus OLS} is an estimation method for gravity models 
developed by Baier and Bergstrand (2009, 2010) using GDP-weights to center a
Taylor-series (see the references for more information). 
To execute the function a square gravity dataset with all pairs of 
countries, ISO-codes for the country of origin and destination, a measure of 
distance between the bilateral partners as well as all 
information that should be considered as dependent an independent 
variables is needed. 
Make sure the ISO-codes are of type "character".
Missing bilateral flows as well as incomplete rows should be 
excluded from the dataset. 
Furthermore, flows equal to zero should be excluded as the gravity equation 
is estimated in its additive form.  
The \code{BVW} function considers Multilateral Resistance terms and allows to 
conduct comparative statics. Country specific effects are subdued due 
to demeaning. Hence, unilateral variables apart from \code{inc_o}
and \code{inc_d} cannot be included in the estimation.
\code{BVW} is designed to be consistent with the Stata code provided at
the website
\href{https://sites.google.com/site/hiegravity/}{Gravity Equations: Workhorse, Toolkit, and Cookbook}
when choosing robust estimation.
As, to our knowledge at the moment, there is no explicit literature covering 
the estimation of a gravity equation by \code{BVW} using panel data, 
we do not recommend to apply this method in this case.
}
\examples{
\dontrun{
data(Gravity)

BVW(y="flow", dist="distw", x=c("rta"), inc_o="gdp_o", inc_d="gdp_d", 
vce_robust=TRUE, data=Gravity)

BVW(y="flow", dist="distw", x=c("rta", "comcur", "contig"), 
inc_o="gdp_o", inc_d="gdp_d", vce_robust=FALSE, data=Gravity)
}

}
\references{
For estimating gravity equations via Bonus Vetus OLS see

Baier, S. L. and Bergstrand, J. H. (2009) <DOI:10.1016/j.jinteco.2008.10.004>

Baier, S. L. and Bergstrand, J. H. (2010) in Van Bergeijk, P. A., & Brakman, S. (Eds.) (2010) chapter 4 <DOI:10.1111/j.1467-9396.2011.01000.x>

For more information on gravity models, theoretical foundations and
estimation methods in general see 

Anderson, J. E. (1979) <DOI:10.12691/wjssh-2-2-5>

Anderson, J. E. (2010) <DOI:10.3386/w16576>

Anderson, J. E. and van Wincoop, E. (2003) <DOI:10.3386/w8079> 

Head, K., Mayer, T., & Ries, J. (2010) <DOI:10.1016/j.jinteco.2010.01.002>

Head, K. and Mayer, T. (2014) <DOI:10.1016/B978-0-444-54314-1.00003-3>

Santos-Silva, J. M. C. and Tenreyro, S. (2006) <DOI:10.1162/rest.88.4.641> 

and the citations therein.

See \href{https://sites.google.com/site/hiegravity/}{Gravity Equations: Workhorse, Toolkit, and Cookbook} for gravity datasets and Stata code for estimating gravity models.
}
\seealso{
\code{\link[stats]{lm}}, \code{\link[lmtest]{coeftest}}, 
\code{\link[sandwich]{vcovHC}}
}

