% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gssi.R
\name{gssi}
\alias{gssi}
\title{Green Space Similarity Index (GSSI)}
\usage{
gssi(green_spaces_list, equal_area_crs = "ESRI:54009")
}
\arguments{
\item{green_spaces_list}{A list of 'sf' objects, each representing the green spaces in a city.}

\item{equal_area_crs}{A character string representing an equal-area CRS for accurate area measurement.
Default is "ESRI:54009".}
}
\value{
A numeric vector of normalized GSSI values for each city.
}
\description{
This function calculates the Green Space Similarity Index (GSSI) for a list of cities,
based on the variability of green space sizes and their connectivity.
The function uses the \code{spatstat} package to calculate proximity measures and combines these
with area-based metrics to form the GSSI. The index is useful for comparing urban green
spaces across different cities.
}
\examples{
\donttest{
d1 <- get_osm_data("New Delhi, India")
dsf <- d1$green_areas$osm_polygons
d2 <- get_osm_data("Basel, Switzerland")
bsf <- d2$green_areas$osm_polygons
d3 <- get_osm_data("Medellin, Colombia")
msf <- d3$green_areas$osm_polygons
cities_data <- list(dsf, bsf, msf)
gssi_values <- gssi(cities_data)
}
}
