% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alm.R
\name{alm}
\alias{alm}
\title{Advanced Linear Model}
\usage{
alm(formula, data, subset = NULL, na.action, distribution = c("laplace",
  "s", "fnorm", "chisq"))
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to
that class): a symbolic description of the model to be fitted.}

\item{data}{a data frame or a matrix, containing the variables in the model.}

\item{subset}{an optional vector specifying a subset of observations to be
used in the fitting process.}

\item{na.action}{a function which indicates what should happen when the
data contain NAs. The default is set by the na.action setting of
\link[base]{options}, and is \link[stats]{na.fail} if that is unset. The
factory-fresh default is \link[stats]{na.omit}. Another possible value
is NULL, no action. Value \link[stats]{na.exclude} can be useful.}

\item{distribution}{What density function to use in the process.}
}
\value{
Function returns \code{model} - the final model of the class
"alm".
}
\description{
Function estimates model based on the selected distribution
}
\details{
This is a function, similar to \link[stats]{lm}, but for the cases of several
non-normal distributions. These include:
\enumerate{
\item Laplace distribution, \link[greybox]{dlaplace},
\item S-distribution, \link[greybox]{ds},
\item Folded-normal distribution, \link[greybox]{dfnorm},
\item Chi-Squared Distribution, \link[stats]{dchisq}.
}

Probably some other distributions will be added to this function at some point...

The estimation is done using likelihood of respective distributions.
}
\examples{

xreg <- cbind(rlaplace(100,10,3),rnorm(100,50,5))
xreg <- cbind(100+0.5*xreg[,1]-0.75*xreg[,2]+rlaplace(100,0,3),xreg,rnorm(100,300,10))
colnames(xreg) <- c("y","x1","x2","Noise")
inSample <- xreg[1:80,]
outSample <- xreg[-c(1:80),]
# Combine all the possible models
ourModel <- alm(y~x1+x2, inSample, distribution="laplace")
summary(ourModel)
plot(forecast(ourModel,outSample))

}
\seealso{
\code{\link[greybox]{stepwise}, \link[greybox]{lmCombine}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
