% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutomaticDemandIdentifier.R
\name{adi}
\alias{adi}
\title{Automatic Demand Identifier}
\usage{
adi(y, ic = c("AICc", "AIC", "BICc", "BIC"), level = 0.99)
}
\arguments{
\item{y}{The vector of the data.}

\item{ic}{Information criterion to use.}

\item{level}{The confidence level used in stockouts identification.}
}
\value{
Class "adi" is returned, which contains:
\itemize{
\item y - The original data;
\item models - All fitted models;
\item ICs - Values of information criteria;
\item type - The type of the identified demand;
\item stockouts - List with start and end ids of potential stockouts;
\item new - Binary showing whether the data start with the abnormal number of zeroes.
Must be a new product then;
\item obsolete - Binary showing whether the data ends with the abnormal number of zeroes.
Must be product that was discontinued (obsolete).
}
}
\description{
The function applies several models on the provided time series and identifies what
type of demand it is based on an information criterion.
}
\details{
In the first step, function creates inter-demand intervals and fits a model with LOWESS
of it assuming Geometric distribution. The outliers from this model are treated as
potential stock outs.

In the second step, the function creates explanatory variables based on LOWESS of the
original data, then applies Normal, Normal + Bernoulli models and selects the one that
has the lowest IC. Based on that, it decides what type of demand the data corresponds
to: regular or intermittent. Finally, if the data is count, the function will identify
that.
}
\examples{
# Data from Poisson distribution
y <- rpois(120, 0.7)
adi(y)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{ts}
