\name{plotdiff}
\alias{plotdiff}
\alias{plotdiffInit}
\alias{plotdiffResult}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Test for identical output from \code{grid.echo()}
}
\description{
  Functions to generate a scene using the \pkg{graphics} package,
  reproduce the scene using \code{grid.echo()}, test whether the
  two results are identical, and report on any differences.
}
\usage{
plotdiff(expr, label, dev = "pdf",
         antialias = TRUE, density = 100, width = 7, height = 7)
plotdiffInit()
plotdiffResult(warn = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{expr}{
    An expression that draws something using the \pkg{graphics} package.
  }
  \item{label}{
    A character value that is used to label files generated during testing.
  }
  \item{dev}{
    The graphics device used for drawing and echoing.  Currently can only be
    either \code{"pdf"} or \code{"png"}.
  }
  \item{antialias}{
    A logical value indicating whether to perform antialiasing when
    converting from PDF to PNG.
  }
  \item{density}{
    A numeric value indicating the resolution (dpi) to use when 
    converting from PDF to PNG.
  }
  \item{width, height}{
    Numeric values indicating the size of the device to test on.
  }
  \item{warn}{
    A logical value indicating whether non-identical output should
    produce a warning or an error.
  }
}
\details{
  In default usage, \code{plotdiff()} is used to generate two PDF
  files, one using the original expression and the other from a call
  to \code{grid.echo()}.  The PDF files are then converted to PNG
  files and the PNG files are compared (using ImageMagick).  If
  there are any differences, the
  comparison generates a further PNG file that shows the differences.

  All files are currently generated in the current working directory.

  Text messages are also generated by \code{plotdiff()} whenever a
  difference is found, but those messages are stored up rather than
  printed immediately.
  The \code{plotdiffResult()} function prints out all messages
  since the last call to \code{plotdiffInit()}.

  Standard usage involves calling \code{plotdiffInit()}, followed by
  one or more \code{plotdiff()} calls, then finally a call to
  \code{plotdiffResult()}.
  Examples of the usage of these functions are provided in the numerous
  test scripts in the \code{test-scripts} directory of the package.
}
\value{
  All functions are run for their side effects.
  In the case of \code{plotdiff()}, the generation of PDF and PNG files
  and the accumulation of differences about messages.
  In the case of \code{plotdiffResult()}, a print out of the accumulated
  messages, plus possibly either an error or warning.
}
\section{Note}{
  The \code{plotdiff()} function only produces PDF files on Windows;
  it neither converts nor compares the PDFs.
  }
%% ~Make other sections like Warning with \section{Warning }{....} ~
\author{
Paul Murrell
}


\seealso{
\code{\link{grid.echo}}
}
\examples{
\dontrun{
plotdiff(expression(plot(1)), "plot")
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ dplot }
