% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_cpa.R
\name{sample_cpa}
\alias{sample_cpa}
\title{Sample Cost Per Activation (CPA)}
\usage{
sample_cpa(input_df, priors, n_samples = 50000)
}
\arguments{
\item{input_df}{Dataframe containing option_name (str), sum_conversions (dbl),
sum_cost (dbl), and sum_clicks (dbl).}

\item{priors}{Optional list of priors {alpha0, beta0} for Beta and {k0, theta0}
for Gamma.
Default \eqn{Beta(1,1)} and \eqn{Gamma(1, 250)} will be use otherwise.}

\item{n_samples}{Optional integer value. Defaults to 50,000 samples.}
}
\value{
input_df with 3 new nested columns `beta_params`, `gamma_params`, and `samples`
}
\description{
Adds 3 new nested columns to the input_df: `beta_params`, `gamma_params`, and `samples`
    `beta_params` and `gamma_params` in each row should be a tibble of length 2 (\eqn{\alpha}
        and \eqn{\beta} parameters and \eqn{k} and \eqn{\theta} parameters)
    `samples` in each row should be a tibble of length `n_samples`
}
\details{
See update_rules vignette for a mathematical representation.
This is a combination of a Beta-Bernoulli update and a Gamma-Exponential update.

\deqn{conversion_i ~ Bernoulli(\phi)}
\deqn{cpc_i ~ Exponential(\lambda)}
\deqn{\phi ~ Beta(\alpha, \beta)}
\deqn{\lambda ~ Gamma(k, \theta)}

\deqn{cpa_i ~ 1/ (Bernoulli(\phi) * Exponential(\lambda))}
\deqn{averageCPA ~ 1/(\phi\lambda)}

Conversion Rate is sampled from a Beta distribution with a Binomial likelihood
of an individual converting.

Average CPC is sampled from a Gamma distribution with an Exponential likelihood
of an individual cost.
}
