% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cost.R
\name{cost}
\alias{cost}
\title{Cost Function for Nonlinear Fits}
\usage{
cost(p, obs, FUN, fixed.p = NULL, ...)
}
\arguments{
\item{p}{vector of fitted parameters of the growth model.}

\item{FUN}{function of growth model to be fitted.}

\item{fixed.p}{vector of fixed  parameters of the growth model.}

\item{\dots}{additional parameters passed to the optimizer.}
}
\value{
an object of class \code{modCost}, see \code{\link{modCost}} in
  package \pkg{FME}
}
\description{
Defines a cost function from the residual sum of squares between model
and observational data.
}
\details{
Function 'cost' is implemented along the lines of the 
following template, see package FME for details:
\preformatted{
cost <- function(p, obs, FUN, fixed.p = NULL, ...) {
  out <- FUN(obs$time, c(p, fixed.p))
  modCost(out, obs, weight = "none", ...)
}
}
}
\keyword{internal}
