% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_info_combo.R
\name{gs_info_combo}
\alias{gs_info_combo}
\title{Information and effect size for MaxCombo test}
\usage{
gs_info_combo(
  enroll_rate = tibble(stratum = "All", duration = c(2, 2, 10), rate = c(3, 6, 9)),
  fail_rate = tibble(stratum = "All", duration = c(3, 100), fail_rate = log(2)/c(9, 18),
    hr = c(0.9, 0.6), dropout_rate = rep(0.001, 2)),
  ratio = 1,
  event = NULL,
  analysis_time = NULL,
  rho,
  gamma,
  tau = rep(-1, length(rho)),
  approx = "asymptotic"
)
}
\arguments{
\item{enroll_rate}{Enrollment rates.}

\item{fail_rate}{Failure and dropout rates.}

\item{ratio}{Experimental:Control randomization ratio (not yet implemented).}

\item{event}{Targeted events at each analysis.}

\item{analysis_time}{Minimum time of analysis.}

\item{rho}{Weighting parameters.}

\item{gamma}{Weighting parameters.}

\item{tau}{Weighting parameters.}

\item{approx}{Approximation method.}
}
\value{
A tibble with columns as test index, analysis index,
analysis time, sample size, number of events, ahr, delta,
sigma2, theta, and statistical information.
}
\description{
Information and effect size for MaxCombo test
}
\examples{
gs_info_combo(rho = c(0, 0.5), gamma = c(0.5, 0), analysis_time = c(12, 24))
}
