% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{fitted.gsl_nls}
\alias{fitted.gsl_nls}
\title{Extract model fitted values}
\usage{
\method{fitted}{gsl_nls}(object, ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
Numeric vector of fitted responses similar to \code{\link[stats]{fitted}}.
}
\description{
Returns the fitted responses from a \code{"gsl_nls"} object. \code{fitted.values}
can also be used as an alias.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n, 
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

fitted(obj)
}
\seealso{
\code{\link[stats]{fitted}}
}
