% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{confint.gsl_nls}
\alias{confint.gsl_nls}
\title{Confidence interval for model parameters}
\usage{
\method{confint}{gsl_nls}(object, parm, level = 0.95, method = c("asymptotic", "profile"), ...)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{parm}{A character vector of parameter names for which to evaluate confidence intervals, defaults
to all parameters.}

\item{level}{A numeric scalar between 0 and 1 giving the level of the parameter confidence intervals.}

\item{method}{Method to be used, either \code{"asymptotic"} for asymptotic confidence intervals or
\code{"profile"} for profile likelihood confidence intervals. The latter is only available for
\code{"gsl_nls"} objects that are also of class \code{"nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
A matrix with columns giving the lower and upper confidence limits for each parameter.
}
\description{
Returns asymptotic or profile likelihood confidence intervals for the parameters in a
fitted \code{"gsl_nls"} object.
}
\details{
Method \code{"asymptotic"} assumes (approximate) normality of the errors in the model and calculates
standard asymptotic confidence intervals based on the quantiles of a t-distritbution. Method \code{"profile"}
calculates profile likelihood confidence intervals using the \code{\link[MASS:confint]{confint.nls}} method
in the \CRANpkg{MASS} package and for this reason is only available for \code{"gsl_nls"} objects that
are \emph{also} of class \code{"nls"}.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n,
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

## asymptotic ci's
confint(obj)
\dontrun{
## profile ci's (requires MASS)
confint(obj, method = "profile")
}
}
\seealso{
\code{\link[stats]{confint}}, \code{\link[MASS:confint]{confint.nls}} in package \CRANpkg{MASS}.
}
