% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{formula.gsl_nls}
\alias{formula.gsl_nls}
\title{Extract model formula}
\usage{
\method{formula}{gsl_nls}(x, ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"gsl_nls"}.}

\item{...}{At present no optional arguments are used.}
}
\value{
If the object inherits from class \code{"nls"} returns the fitted model as a \link{formula} similar
to \code{\link[stats]{formula}}. Otherwise returns the fitted model as a \link{function}.
}
\description{
Returns the model formula from a fitted \code{"gsl_nls"} object.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n,
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

formula(obj)
}
\seealso{
\code{\link[stats]{formula}}
}
