% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_test.R
\name{nls_test_list}
\alias{nls_test_list}
\title{Available NLS test problems}
\usage{
nls_test_list(fields = c("name", "class", "p", "n", "check"))
}
\arguments{
\item{fields}{optional character vector to return a subset of columns in the \link{data.frame}.}
}
\value{
a \link{data.frame} with high-level information about the available test problems. The following columns are returned by default:
\itemize{
\item \code{"name"} Name of the test problem for use in \code{\link{nls_test_problem}}.
\item \code{"class"} Either \code{"formula"} if the model is defined as a \link{formula} or \code{"function"} if defined as a \link{function}.
\item \code{"p"} Default number of parameters in the test problem.
\item \code{"n"} Default number of residuals in the test problem.
\item \code{"check"} One of the following three options: (1) \code{"p, n fixed"} if the listed values for \code{p} and \code{n} are the only ones possible;
(2) \code{"p <= n free"} if the values for \code{p} and \code{n} are not fixed, but \code{p} must be smaller or equal to \code{n};
(3) \code{"p == n free"} if the values for \code{p} and \code{n} are not fixed, but \code{p} must be equal to \code{n}.
}
}
\description{
Returns an overview of 56 NLS test problems originating primarily from the NIST Statistical Reference Datasets (StRD)
archive and More, Garbow and Hillstrom (1981).
}
\examples{
## available test problems
nls_test_list()
}
\references{
J.J. Moré, Garbow, B.S. and Hillstrom, K.E. (1981). \emph{Testing unconstrained optimization software}, ACM Transactions on Mathematical Software, 7(1), 17-41.
}
\seealso{
\code{\link{nls_test_problem}}

\url{https://www.itl.nist.gov/div898/strd/nls/nls_main.shtml}

\url{https://people.math.sc.edu/Burkardt/f_src/test_nls/test_nls.html}
}
