% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_thrs_NOR.R
\name{cp_thrs_NOR}
\alias{cp_thrs_NOR}
\title{Compute normalized association measure}
\usage{
cp_thrs_NOR(dv, ivs, s0_perc = NULL, scale_dv = TRUE, scale_ivs = TRUE)
}
\arguments{
\item{dv}{numeric vector of dependent variable values}

\item{ivs}{\eqn{n \times p} matrix of numeric independent variables}

\item{s0_perc}{numeric vector of length 1 storing the factor for the denominator of association statistic (i.e., the percentile of standard deviation values added to the denominator, a value between 0 and 1.) The default is 0.5 (the median)}

\item{scale_dv}{logical value defining whether \code{dv} should be scaled}

\item{scale_ivs}{logical value defining whether \code{ivs} should be scaled}
}
\value{
numeric vector of bivariate association measures between \code{dv} and \code{ivs}. numeric vector of log-likelihood value from all of the univariate GLM models regressing \code{dv} on each column of \code{ivs}.
}
\description{
A function to compute the normalized bivariate association measures between a \code{dv} and a collection of \code{ivs}.
}
\details{
This function is based on the function \code{cor.func} in the package \code{superpc}.
}
\examples{
# Example inputs
dv <- mtcars[, 1]
ivs <- mtcars[, -1]
s0_perc <- 0

# Use the function
cp_thrs_NOR(dv, ivs, s0_perc)

}
\references{
Bair E, Hastie T, Paul D, Tibshirani R (2006). “Prediction by supervised principal components.” J. Am. Stat. Assoc., 101(473), 119-137.
}
\author{
Edoardo Costantini, 2023
}
