% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LL_cumulative.R
\name{LL_cumulative}
\alias{LL_cumulative}
\title{Proportional odds model log-likelihood}
\usage{
LL_cumulative(y, x, mod)
}
\arguments{
\item{y}{ordered factor or disjunctive table representation recording an ordinal variable with 3 or more categories.}

\item{x}{data.frame (or matrix) containing predictor values.}

\item{mod}{\code{polr} object containing the estimated proportional odds model.}
}
\value{
A list containing:
\itemize{
\item \code{ll} an atomic vector of length 1 containing the log-likelihood value.
\item \code{sc}, a numeric matrix containing the systematic component for the input \code{x} and \code{mod}.
}
}
\description{
Computes the log-likelihood given an ordered category response vector and corresponding GLM linear predictor values.
}
\details{
If \code{x} and \code{y} are equal to the data on which \code{mod} has been trained, this function returns the same result as the default \code{logLink} function. If \code{x} and \code{y} are new, the function returns the log-likelihood of the new data under the trained model.
The log-likelihood equation is based on Agresti (2002, p. 192).
}
\references{
Agresti, A. (2012). Categorical data analysis (Vol. 792). John Wiley & Sons.
}
\author{
Edoardo Costantini, 2022
}
