% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refinedBoundaries.R
\name{secondaryBoundaryVecOrig}
\alias{secondaryBoundaryVecOrig}
\title{Calculate Refined Secondary Boundaries and Nominal Significance, Standard Approach}
\usage{
secondaryBoundaryVecOrig(alpha, tVec, primaryOBF = TRUE,
  secondaryOBF = FALSE, nRepVec = c(10, 10, 10, 10), initIntvl = c(1, 8))
}
\arguments{
\item{alpha}{type I error probability.}

\item{tVec}{vector of relative information levels. The last element in the vector is 1.}

\item{primaryOBF}{type of primary boundary, \code{TURE} is the O'Brien-Fleming boundary, \code{FALSE} is the Pocock boundary.}

\item{secondaryOBF}{type of secondary boundary, \code{TURE} is the O'Brien-Fleming boundary, \code{FALSE} is the Pocock boundary.}

\item{nRepVec}{computing paramter, number of replica, a vector of four numbers.}

\item{initIntvl}{computing paramter, a pair of numbers containing the end-points of the interval to be searched for the root.}
}
\value{
a result list including standard refined secondary boundary and the nominal significance for the secondary endpoint.
}
\description{
Standard refined secondary boundaries, and nominal significance for the secondary endpoint are calculated by using the standard (original) approach.
}
\details{
This function uses the standard approach (O'Brien and Fleming 1979, Pocock 1977),
and gives a list including refined secondary boundary and the nominal significance for the secondary endpoint.
There are two computing parameters \code{nRepVec} and \code{initIntvl}. Parameter \code{nRepVec} includes four numbers:
\code{nRepVec[1]} is the number of replica for calculating primary boundaries,
\code{nRepVec[2]} is the number of replica for searching the location of peak,
\code{nRepVec[3]} is the number of replica for calculating secondary boundaries,
\code{nRepVec[4]} is the number of replica for calculating the nominal significance.
Parameter \code{initIntvl} contains the end-points of the interval to be searched for the root.
The lower end point should choose a number around 1,
and the upper end point should choose a number between 4 and 10.
}
\examples{
#require(mvtnorm)
#require(ldbounds)
#result <- secondaryBoundaryVecOrig(alpha=0.025,tVec=c(1/2,1),primaryOBF=TRUE,
#        secondaryOBF=FALSE, nRepVec=c(1,1,1,1),initIntvl=c(1,4))
#result$secondaryBoundary
#result$nomialSignificance

}
\references{
Glimm, E., Maurer, W., and Bretz, F. (2010). Hierarchical testing of multiple endpoints in group-sequential trials. \emph{Statistics in Medicine} \bold{29}, 219-228.

 Hung, H. M. J., Wang, S.-J., and O'Neill, R. (2007). Statistical considerations for testing multiple endpoints in group sequential or adaptive clinical trials. \emph{Journal of Biopharmaceutical Statistics} \bold{17}, 1201-1210.

 Jennison, C. and Turnbull, B. W. (2000). \emph{Group Sequential Methods with Applications to Clinical Trials}. Chapman and Hall/CRC, New York.

 O'Brien, P. C., and Fleming, T. R. (1979). A multiple testing procedure for clinical trials. \emph{Biometrics} \bold{35}, 549-556.

 Pocock, S. J. (1977). Group sequential methods in the design and analysis of clinical trials. \emph{Biometrika} \bold{64}, 191-199.

 Tamhane, A. C., Mehta, C. R., and Liu, L. (2010). Testing a primary and a secondary endpoint in a group sequential design. \emph{Biometrics} \bold{66}, 1174-1184.

 Tamhane, A. C., Gou, J., Jennison, C., Mehta, C. R., and Curto, T. (2017+). A gatekeeping procedure to test a primary and a secondary endpoint in a group sequential design with multiple interim looks. \emph{Biometrics}, to appear.
}
\seealso{
\code{secondaryBoundaryVec}, \code{secondaryBoundaryVecLD}
}
\author{
Jiangtao Gou
}
