% Generated by roxygen2 (4.0.1): do not edit by hand
\name{genotype_frequencies}
\alias{genotype_frequencies}
\title{Genotype Frequencies}
\usage{
genotype_frequencies(x)
}
\arguments{
\item{x}{An object of type \code{locus}}
}
\value{
A \code{data.frame} with genotype, observed, and expected as counts.
}
\description{
Provides a summary of gentoype frequencies (observed and expected) from
 a vector of \code{locus} objects.
}
\examples{
freqs <- c(0.55, 0.30, 0.15)
  alleles <- c(LETTERS[1:3])
  f <- data.frame(Locus="PGM", Allele=alleles, Frequency=freqs)
  data <- make_population(f,N=20)
  table(data$PGM)
  genotype_frequencies( data$PGM )
}
\author{
Rodney J. Dyer \email{rjdyer@vcu.edu}
}

