\name{strapply}
\alias{strapply}
\title{  
 Apply a function over a string or strings.
}
\description{
Similar to \code{"'gsubfn'"} except instead of performing substitutions
it returns the output of \code{"'FUN'"}.}
\usage{
strapply(X, pattern, FUN = function(x, ...) x, ..., 
   simplify = FALSE, USE.NAMES = FALSE)
}
\arguments{
  \item{X}{ list or (atomic) vector of character strings to be used. }
  \item{pattern}{ character string containing a regular expression (or
          character string for \code{"'fixed = TRUE')"} to be matched in the
          given character vector.
}
  \item{FUN}{ the function to be applied to each element of \code{"'X'"}. }
  \item{\dots}{ optional arguments to \code{"'gsubfn'"}. }
  \item{simplify}{  logical; should the result be simplified to a vector or
          matrix, as in \code{"sapply"} if possible?}
  \item{USE.NAMES}{ 
logical; if \code{"'TRUE'"} and if \code{"'X'"} is character, use 
\code{"'X'"} as
          'names' for the result unless it had names already.
}
}
\details{
For each character string in \code{"X"} the pattern is repeatedly
matched, 
each such match along with
backreferences, if any, are passed to 
the function \code{"FUN"} and the output is returned as a list.
}
\value{
A list of character strings.
}
\seealso{ See Also as \code{\link{gsubfn}}, \code{\link{sapply}}}
\examples{

strapply("12;34:56,89,,12", "[0-9]+")

\dontrun{
# convert to chron
library(chron)
x <- c("01/15/2005 23:32:45", "02/27/2005 01:22:30")
x.chron <- strapply(x, "(../../....) (..:..:..)",  chron, backref = -2)
do.call(c, x.chron)

}
}
\keyword{character}
