% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_SR_from_SP}
\alias{gsw_SR_from_SP}
\title{Calculate Reference Salinity from Practical Salinity}
\usage{
gsw_SR_from_SP(SP)
}
\arguments{
\item{SP}{Practical Salinity (PSS-78) [ unitless ]}
}
\value{
Reference Salinity [ g/kg ]
}
\description{
Calculate Reference Salinity from Practical Salinity
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SP <- c(34.5487, 34.7275, 34.8605, 34.6810, 34.5680, 34.5600)
SR <- gsw_SR_from_SP(SP)
stopifnot(all.equal(SR, c(34.711611927085727, 34.891255045714303, 35.024882197714305,
                          34.844535778285724, 34.731002934857159, 34.722965211428587)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_SR_from_SP.html}
}
\seealso{
Other things related to salinity: 
\code{\link{gsw_C_from_SP}()},
\code{\link{gsw_SA_from_SP_Baltic}()},
\code{\link{gsw_SA_from_SP}()},
\code{\link{gsw_SA_from_Sstar}()},
\code{\link{gsw_SP_from_C}()},
\code{\link{gsw_SP_from_SA}()},
\code{\link{gsw_SP_from_SK}()},
\code{\link{gsw_SP_from_SR}()},
\code{\link{gsw_SP_from_Sstar}()},
\code{\link{gsw_Sstar_from_SA}()},
\code{\link{gsw_Sstar_from_SP}()},
\code{\link{gsw_deltaSA_from_SP}()}
}
\concept{things related to salinity}
