% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_entropy_first_derivatives}
\alias{gsw_entropy_first_derivatives}
\title{First Derivatives of Entropy}
\usage{
gsw_entropy_first_derivatives(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
a list containing \code{eta_SA} [ (J/(kg*degC) / (g/kg) ],
the derivative of entropy wrt Absolute Salinity, and \code{eta_CT} [ (J/(kg*degC^2) ],
the derivative of entropy wrt Conservative Temperature.
}
\description{
First Derivatives of Entropy
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
d <- gsw_entropy_first_derivatives(SA, CT)
stopifnot(all.equal(d$eta_SA, c(-0.263286800711655, -0.263977276574528, -0.255367497912925,
                                -0.238066586439561, -0.234438260606436, -0.232820684341694)))
stopifnot(all.equal(d$eta_CT, c(13.221031210083824, 13.236911191313675, 13.489004628681361,
                                14.086599016583795, 14.257729576432077, 14.386429945649411)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_entropy_first_derivatives.html}
}
\seealso{
Other things related to entropy: 
\code{\link{gsw_CT_from_entropy}()},
\code{\link{gsw_entropy_from_pt}()},
\code{\link{gsw_entropy_from_t}()},
\code{\link{gsw_entropy_ice}()},
\code{\link{gsw_pt_from_entropy}()}
}
\concept{things related to entropy}
