% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsw.R
\name{gsw_sigma4}
\alias{gsw_sigma4}
\title{Potential density anomaly referenced to 4000 dbar}
\usage{
gsw_sigma4(SA, CT)
}
\arguments{
\item{SA}{Absolute Salinity [ g/kg ]}

\item{CT}{Conservative Temperature [ degC ]}
}
\value{
potential density anomaly with reference pressure 4000 dbar [ kg/m^3 ]
}
\description{
This uses the 75-term density equation, and returns
potential density referenced to a pressure of 4000 dbar,
minus 1000 kg/m^3.
}
\section{Implementation Note}{


This R function uses a wrapper to a C function contained within the GSW-C
system as updated 2021-12-28 at \url{https://github.com/TEOS-10/GSW-C} with
git commit `98f0fd40dd9ceb0ba82c9d47ac750e935a7d0459`.

The C function uses data from the \code{library/gsw_data_v3_0.mat}
file provided in the GSW-Matlab source code, version 3.06-11.
Unfortunately, this version of the mat file is no longer displayed on the
TEOS-10.org website.  Therefore, in the interests of making GSW-R be
self-contained, a copy was downloaded from
\url{http://www.teos-10.org/software/gsw_matlab_v3_06_11.zip} on 2022-05-25,
the .mat file was stored in the developer/create_data directory of
\url{https://github.com/TEOS-10/GSW-R}, and then the dataset used in GSW-R
was created based on that .mat file.

Please consult \url{http://www.teos-10.org} to learn more about the various
TEOS-10 software systems.
}

\examples{
SA <- c(34.7118, 34.8915, 35.0256, 34.8472, 34.7366, 34.7324)
CT <- c(28.8099, 28.4392, 22.7862, 10.2262,  6.8272,  4.3236)
sigma4 <- gsw_sigma4(SA,CT)
stopifnot(all.equal(sigma4, c(37.900374609834898, 38.166979617032439, 40.280876075282549,
                              43.896091033421953, 44.631677245327637, 45.171817312020039)))
}
\references{
\url{http://www.teos-10.org/pubs/gsw/html/gsw_sigma4.html}
}
\seealso{
Other things related to density: 
\code{\link{gsw_CT_from_rho}()},
\code{\link{gsw_CT_maxdensity}()},
\code{\link{gsw_SA_from_rho}()},
\code{\link{gsw_alpha_on_beta}()},
\code{\link{gsw_alpha_wrt_t_exact}()},
\code{\link{gsw_alpha_wrt_t_ice}()},
\code{\link{gsw_alpha}()},
\code{\link{gsw_beta_const_t_exact}()},
\code{\link{gsw_beta}()},
\code{\link{gsw_pot_rho_t_exact}()},
\code{\link{gsw_rho_alpha_beta}()},
\code{\link{gsw_rho_first_derivatives_wrt_enthalpy}()},
\code{\link{gsw_rho_first_derivatives}()},
\code{\link{gsw_rho_ice}()},
\code{\link{gsw_rho_t_exact}()},
\code{\link{gsw_rho}()},
\code{\link{gsw_sigma0}()},
\code{\link{gsw_sigma1}()},
\code{\link{gsw_sigma2}()},
\code{\link{gsw_sigma3}()},
\code{\link{gsw_specvol_alpha_beta}()},
\code{\link{gsw_specvol_anom_standard}()},
\code{\link{gsw_specvol_ice}()},
\code{\link{gsw_specvol_t_exact}()},
\code{\link{gsw_specvol}()}
}
\concept{things related to density}
