% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_remove.R
\name{rm_caption}
\alias{rm_caption}
\title{Remove the table caption}
\usage{
rm_caption(data)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
We can easily remove the caption text from a \strong{gt} table with
\code{rm_caption()}. The caption may exist if it were set through the \code{\link[=gt]{gt()}}
\code{caption} argument or via \code{\link[=tab_caption]{tab_caption()}}.

This function for removal is useful if you have received a \strong{gt} table
(perhaps through an API that returns \strong{gt} objects) but would prefer that
the table not have a caption at all. This function is safe to use even if
there is no table caption set in the input \code{gt_tbl} object.
}
\section{Examples}{


Use a portion of the \code{\link{gtcars}} dataset to create a \strong{gt} table. We'll add a
header part with the \code{\link[=tab_header]{tab_header()}} function, and, a caption will also be
added via the \code{\link[=tab_caption]{tab_caption()}} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gt_tbl <-
  gtcars |>
  dplyr::select(mfr, model, msrp) |>
  dplyr::slice(1:5) |>
  gt() |>
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) |>
  tab_caption(caption = md("**gt** table example."))

gt_tbl
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_rm_caption_1.png" alt="This image of a table was generated from the first code example in the `rm_caption()` help file." style="width:100\%;">
}}

If you decide that you don't want the caption in the \code{gt_tbl} object,
it can be removed with the \code{rm_caption()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{rm_caption(data = gt_tbl)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_rm_caption_2.png" alt="This image of a table was generated from the second code example in the `rm_caption()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

7-6
}

\section{Function Introduced}{

\code{v0.8.0} (November 16, 2022)
}

\seealso{
Other part removal functions: 
\code{\link{rm_footnotes}()},
\code{\link{rm_header}()},
\code{\link{rm_source_notes}()},
\code{\link{rm_spanners}()},
\code{\link{rm_stubhead}()}
}
\concept{part removal functions}
