% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt_datetime}
\alias{fmt_datetime}
\title{Format values as date-times}
\usage{
fmt_datetime(data, columns, rows = NULL, date_style = 2, time_style = 2)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=vars]{vars()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, and \code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Not providing any value results in all
rows in \code{columns} being formatted. Can either be a vector of row captions
provided \code{\link[=c]{c()}}, a vector of row indices, or a helper function focused on
selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, and \code{\link[=everything]{everything()}}.
We can also use expressions to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{date_style}{The date style to use. Supply a number (from \code{1} to \code{14})
that corresponds to the preferred date style. Use \code{\link[=info_date_style]{info_date_style()}} to
see the different numbered and named date presets.}

\item{time_style}{The time style to use. Supply a number (from \code{1} to \code{5})
that corresponds to the preferred time style. Use \code{\link[=info_time_style]{info_time_style()}} to
see the different numbered and named time presets.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Format input date-time values that are character-based and expressed
according to the ISO 8601 date-time format (\verb{YYYY-MM-DD HH:MM:SS}). Once the
appropriate data cells are targeted with \code{columns} (and, optionally, \code{rows}),
we can simply apply preset date and time styles to format the date-time
values. The following date styles are available for simpler formatting of the
date portion (all using the input date of \code{2000-02-29} in the example output
dates):
\enumerate{
\item iso: \code{2000-02-29}
\item wday_month_day_year: \verb{Tuesday, February 29, 2000}
\item wd_m_day_year: \verb{Tue, Feb 29, 2000}
\item wday_day_month_year: \verb{Tuesday 29 February 2000}
\item month_day_year: \verb{February 29, 2000}
\item m_day_year: \verb{Feb 29, 2000}
\item day_m_year: \verb{29 Feb 2000}
\item day_month_year: \verb{29 February 2000}
\item day_month: \verb{29 February}
\item year: \code{2000}
\item month: \code{February}
\item day: \code{29}
\item year.mn.day: \code{2000/02/29}
\item y.mn.day: \code{0/02/29}
}
The following time styles are available for simpler formatting of the time
portion (all using the input time of \code{14:35:00} in the example output times):
\enumerate{
\item hms: \code{14:35:00}
\item hm: \code{14:35}
\item hms_p: \verb{2:35:00 PM}
\item hm_p: \verb{2:35 PM}
\item h_p: \verb{2 PM}
}
We can use the \code{\link[=info_date_style]{info_date_style()}} and \code{\link[=info_time_style]{info_time_style()}} functions as
useful references for all of the possible inputs to \code{date_style} and
\code{time_style}.
}
\details{
Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). A number of
helper functions exist to make targeting more effective. Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the Arguments section for more information on this.
}
\section{Figures}{

\if{html}{\figure{man_fmt_datetime_1.png}{options: width=100\%}}
}

\section{Function ID}{

3-7
}

\examples{
# Use `exibble` to create a gt table;
# keep only the `datetime` column;
# format the column to have dates
# formatted as `month_day_year` and
# times to be `hms_p`
tab_1 <-
  exibble \%>\%
  dplyr::select(datetime) \%>\%
  gt() \%>\%
  fmt_datetime(
    columns = vars(datetime),
    date_style = 5,
    time_style = 3
  )

}
\seealso{
Other Format Data: 
\code{\link{data_color}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_date}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_missing}()},
\code{\link{fmt_number}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{fmt}()},
\code{\link{text_transform}()}
}
\concept{Format Data}
