% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{cells_summary}
\alias{cells_summary}
\title{Location helper for targeting group summary cells}
\usage{
cells_summary(groups = TRUE, columns = TRUE, rows = TRUE)
}
\arguments{
\item{groups}{The names of the groups that the summary rows reside in.}

\item{columns}{The names of the columns that are to be targeted.}

\item{rows}{The names of the rows that are to be targeted.}
}
\value{
A list object with the classes \code{cells_summary} and \code{location_cells}.
}
\description{
The \code{cells_summary()} function is used to target the cells in a group summary
and it is useful when applying a footnote with \code{\link[=tab_footnote]{tab_footnote()}} or adding a
custom style with \code{\link[=tab_style]{tab_style()}}. The function is expressly used in each of
those functions' \code{locations} argument.
}
\details{
When using any of the location helper functions with an appropriate function
that has a \code{locations} argument, multiple locations can be targeted by
enclosing several \verb{cells_*()} helper functions in a \code{list()}. The following
helper functions can be used to target cells (roughly in order from the top
to the bottom of a table):
\itemize{
\item \code{\link[=cells_title]{cells_title()}}: targets the table title or the table subtitle
depending on the value given to the \code{groups} argument (\code{"title"} or
\code{"subtitle"}).
\item \code{\link[=cells_stubhead]{cells_stubhead()}}: targets the stubhead location, a cell of which is
only available when there is a stub; a label in that location can be created
by using the \code{\link[=tab_stubhead]{tab_stubhead()}} function.
\item \code{\link[=cells_column_spanners]{cells_column_spanners()}}: targets the spanner column labels, which
appear above the column labels.
\item \code{\link[=cells_column_labels]{cells_column_labels()}}: targets the column labels.
\item \code{\link[=cells_row_groups]{cells_row_groups()}}: targets the row group labels in any available row
groups using the \code{groups} argument.
\item \code{\link[=cells_stub]{cells_stub()}}: targets row labels in the table stub using the \code{rows}
argument.
\item \code{\link[=cells_body]{cells_body()}}: targets data cells in the table body using
intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_summary]{cells_summary()}}: targets summary cells in the table body using the
\code{groups} argument and intersections of \code{columns} and \code{rows}.
\item \code{\link[=cells_grand_summary]{cells_grand_summary()}}: targets cells of the table's grand summary
using intersections of \code{columns} and \code{rows}
}
}
\section{Figures}{

\if{html}{\figure{man_cells_summary_1.png}{options: width=100\%}}
}

\section{Function ID}{

7-12
}

\examples{
# Use `countrypops` to create a gt table; add
# some styling to the summary data cells with
# with `tab_style()`, using `cells_summary()`
# in `locations`
tab_1 <-
  countrypops \%>\%
  dplyr::filter(
    country_name == "Japan",
    year < 1970) \%>\%
  dplyr::select(-contains("country")) \%>\%
  dplyr::mutate(
    decade = paste0(substr(year, 1, 3), "0s")
  ) \%>\%
  dplyr::group_by(decade) \%>\%
  gt(
    rowname_col = "year",
    groupname_col = "decade"
  ) \%>\%
  fmt_number(
    columns = vars(population),
    decimals = 0
  ) \%>\%
  summary_rows(
    groups = "1960s",
    columns = vars(population),
    fns = list("min", "max"),
    formatter = fmt_number,
    decimals = 0
  ) \%>\%
  tab_style(
    style = list(
      cell_text(style = "italic"),
      cell_fill(color = "lightblue")
      ),
    locations = cells_summary(
      groups = "1960s",
      columns = vars(population),
      rows = 1)
  ) \%>\%
  tab_style(
    style = list(
      cell_text(style = "italic"),
      cell_fill(color = "lightgreen")
      ),
    locations = cells_summary(
      groups = "1960s",
      columns = vars(population),
      rows = 2)
  )

}
\seealso{
Other Helper Functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{google_font}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()}
}
\concept{Helper Functions}
