% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_rows.R
\name{grand_summary_rows}
\alias{grand_summary_rows}
\title{Add grand summary rows using aggregation functions}
\usage{
grand_summary_rows(
  data,
  columns = everything(),
  fns,
  missing_text = "---",
  formatter = fmt_number,
  ...
)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns for which the summaries should be calculated.}

\item{fns}{Functions used for aggregations. This can include base functions
like \code{mean}, \code{min}, \code{max}, \code{median}, \code{sd}, or \code{sum} or any other
user-defined aggregation function. The function(s) should be supplied
within a \code{list()}. Within that list, we can specify the functions by use of
function names in quotes (e.g., \code{"sum"}), as bare functions (e.g., \code{sum}),
or as one-sided R formulas using a leading \code{~}. In the formula
representation, a \code{.} serves as the data to be summarized (e.g., \code{sum(., na.rm = TRUE)}). The use of named arguments is recommended as the names
will serve as summary row labels for the corresponding summary rows data
(the labels can derived from the function names but only when not providing
bare function names).}

\item{missing_text}{The text to be used in place of \code{NA} values in summary
cells with no data outputs.}

\item{formatter}{A formatter function name. These can be any of the \verb{fmt_*()}
functions available in the package (e.g., \code{\link[=fmt_number]{fmt_number()}}, \code{\link[=fmt_percent]{fmt_percent()}},
etc.), or a custom function using \code{fmt()}. The default function is
\code{\link[=fmt_number]{fmt_number()}} and its options can be accessed through \code{...}.}

\item{...}{Values passed to the \code{formatter} function, where the provided
values are to be in the form of named vectors. For example, when using the
default \code{formatter} function, \code{\link[=fmt_number]{fmt_number()}}, options such as \code{decimals},
\code{use_seps}, and \code{locale} can be used.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Add grand summary rows to the \strong{gt} table by using applying aggregation
functions to the table data. The summary rows incorporate all of the
available data, regardless of whether some of the data are part of row
groups. You choose how to format the values in the resulting summary cells by
use of a \code{formatter} function (e.g, \code{fmt_number}) and any relevant options.
}
\details{
Should we need to obtain the summary data for external purposes, the
\code{\link[=extract_summary]{extract_summary()}} function can be used with a \code{gt_tbl} object where grand
summary rows were added via \code{grand_summary_rows()}.
}
\section{Examples}{


Use \code{\link{sp500}} to create a \strong{gt} table with row groups. Create the grand
summary rows \code{min}, \code{max}, and \code{avg} for the table with the
\code{grand_summary_rows()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sp500 \%>\%
  dplyr::filter(date >= "2015-01-05" & date <= "2015-01-16") \%>\%
  dplyr::arrange(date) \%>\%
  dplyr::mutate(week = paste0("W", strftime(date, format = "\%V"))) \%>\%
  dplyr::select(-adj_close, -volume) \%>\%
  gt(
    rowname_col = "date",
    groupname_col = "week"
  ) \%>\%
  grand_summary_rows(
    columns = c(open, high, low, close),
    fns = list(
      min = ~min(.),
      max = ~max(.),
      avg = ~mean(.)),
    formatter = fmt_number,
    use_seps = FALSE
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_grand_summary_rows_1.png" style="width:100\%;">
}}
}

\section{Function ID}{

6-2
}

\seealso{
Other Add Rows: 
\code{\link{summary_rows}()}
}
\concept{Add Rows}
