% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_tables.R
\name{info_google_fonts}
\alias{info_google_fonts}
\title{View a table on recommended Google Fonts}
\usage{
info_google_fonts()
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{\link[=google_font]{google_font()}} helper function can be used wherever a font name should
be specified. There are two instances where this helper can be used: the
\code{name} argument in \code{\link[=opt_table_font]{opt_table_font()}} (for setting a table font) and in that
of \code{\link[=cell_text]{cell_text()}} (used with \code{\link[=tab_style]{tab_style()}}). Because there is an overwhelming
number of fonts available in the \emph{Google Fonts} catalog, the
\code{info_google_fonts()} provides a table with a set of helpful font
recommendations. These fonts look great in the different parts of a \strong{gt}
table. Why? For the most part they are suitable for body text, having large
counters, large x-height, reasonably low contrast, and open apertures. These
font features all make for high legibility at smaller sizes.
}
\section{Examples}{


Get a table of info on some of the recommended \emph{Google Fonts} for tables.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{info_google_fonts()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_info_google_fonts_1.png" style="width:100\%;">
}}
}

\section{Function ID}{

10-6
}

\seealso{
Other Information Functions: 
\code{\link{info_currencies}()},
\code{\link{info_date_style}()},
\code{\link{info_locales}()},
\code{\link{info_paletteer}()},
\code{\link{info_time_style}()}
}
\concept{Information Functions}
