% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_columns.R
\name{cols_move_to_start}
\alias{cols_move_to_start}
\title{Move one or more columns to the start}
\usage{
cols_move_to_start(data, columns)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The column names to move to the left-most side of the table.
The order in which columns are provided will be preserved (as is the case
with the remaining columns).}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
We can easily move set of columns to the beginning of the column series and
we only need to specify which \code{columns}. It's possible to do this upstream of
\strong{gt}, however, it is easier with this function and it presents less
possibility for error. The ordering of the \code{columns} that are moved to the
start is preserved (same with the ordering of all other columns in the
table).
}
\details{
The columns supplied in \code{columns} must all exist in the table. If you need to
place one or columns at the end of the column series, the
\code{\link[=cols_move_to_end]{cols_move_to_end()}} function should be used. More control is offered with
the \code{\link[=cols_move]{cols_move()}} function, where columns could be placed after a specific
column.
}
\section{Examples}{


Use \code{\link{countrypops}} to create a \strong{gt} table. With the remaining columns,
move the \code{year} column to the start of the column series with
\code{cols_move_to_start()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops \%>\%
  dplyr::select(-contains("code")) \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_move_to_start(columns = year)
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_move_to_start_1.png" alt="This image of a table was generated from the first code example in the `cols_move_to_start()` help file." style="width:100\%;">
}}

Use \code{\link{countrypops}} to create a \strong{gt} table. With the remaining columns,
move \code{year} and \code{population} to the start.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{countrypops \%>\%
  dplyr::select(-contains("code")) \%>\%
  dplyr::filter(country_name == "Mongolia") \%>\%
  tail(5) \%>\%
  gt() \%>\%
  cols_move_to_start(columns = c(year, population))
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_cols_move_to_start_2.png" alt="This image of a table was generated from the second code example in the `cols_move_to_start()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

4-4
}

\seealso{
Other column modification functions: 
\code{\link{cols_align}()},
\code{\link{cols_hide}()},
\code{\link{cols_label}()},
\code{\link{cols_merge_n_pct}()},
\code{\link{cols_merge_range}()},
\code{\link{cols_merge_uncert}()},
\code{\link{cols_merge}()},
\code{\link{cols_move_to_end}()},
\code{\link{cols_move}()},
\code{\link{cols_unhide}()},
\code{\link{cols_width}()}
}
\concept{column modification functions}
