% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{fmt}
\alias{fmt}
\title{Set a column format with a formatter function}
\usage{
fmt(data, columns = everything(), rows = everything(), fns)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{columns}{The columns to format. Can either be a series of column names
provided in \code{\link[=c]{c()}}, a vector of column indices, or a helper function
focused on selections. The select helper functions are: \code{\link[=starts_with]{starts_with()}},
\code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and
\code{\link[=everything]{everything()}}.}

\item{rows}{Optional rows to format. Providing \code{\link[=everything]{everything()}} (the
default) results in all rows in \code{columns} being formatted. Alternatively,
we can supply a vector of row captions within \code{\link[=c]{c()}}, a vector of row
indices, or a helper function focused on selections. The select helper
functions are: \code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}},
\code{\link[=one_of]{one_of()}}, \code{\link[=num_range]{num_range()}}, and \code{\link[=everything]{everything()}}. We can also use expressions
to filter down to the rows we need (e.g.,
\verb{[colname_1] > 100 & [colname_2] < 50}).}

\item{fns}{Either a single formatting function or a named list of functions.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{fmt()} function provides a way to execute custom formatting
functionality with raw data values in a way that can consider all output
contexts.

Along with the \code{columns} and \code{rows} arguments that provide some precision in
targeting data cells, the \code{fns} argument allows you to define one or more
functions for manipulating the raw data.

If providing a single function to \code{fns}, the recommended format is in the
form: \code{fns = function(x) ...}. This single function will format the targeted
data cells the same way regardless of the output format (e.g., HTML, LaTeX,
RTF).

If you require formatting of \code{x} that depends on the output format, a list of
functions can be provided for the \code{html}, \code{latex}, \code{rtf}, and \code{default}
contexts. This can be in the form of \code{fns = list(html = function(x) ..., latex = function(x) ..., default = function(x) ...)}. In this
multiple-function case, we recommended including the \code{default} function as a
fallback if all contexts aren't provided.
}
\section{Targeting the values to be formatted}{


Targeting of values is done through \code{columns} and additionally by \code{rows} (if
nothing is provided for \code{rows} then entire columns are selected). Conditional
formatting is possible by providing a conditional expression to the \code{rows}
argument. See the \emph{Arguments} section for more information on this.
}

\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table. Format the numeric values in the
\code{num} column with a function supplied to the \code{fns} argument.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  dplyr::select(-row, -group) \%>\%
  gt() \%>\%
  fmt(
    columns = num,
    fns = function(x) \{
      paste0("'", x * 1000, "'")
    \}
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_fmt_1.png" alt="This image of a table was generated from the first code example in the `fmt()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

3-17
}

\seealso{
Other data formatting functions: 
\code{\link{data_color}()},
\code{\link{fmt_bytes}()},
\code{\link{fmt_currency}()},
\code{\link{fmt_datetime}()},
\code{\link{fmt_date}()},
\code{\link{fmt_duration}()},
\code{\link{fmt_engineering}()},
\code{\link{fmt_fraction}()},
\code{\link{fmt_integer}()},
\code{\link{fmt_markdown}()},
\code{\link{fmt_number}()},
\code{\link{fmt_partsper}()},
\code{\link{fmt_passthrough}()},
\code{\link{fmt_percent}()},
\code{\link{fmt_roman}()},
\code{\link{fmt_scientific}()},
\code{\link{fmt_time}()},
\code{\link{sub_large_vals}()},
\code{\link{sub_missing}()},
\code{\link{sub_small_vals}()},
\code{\link{sub_values}()},
\code{\link{sub_zero}()},
\code{\link{text_transform}()}
}
\concept{data formatting functions}
