% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_transform.R
\name{text_case_when}
\alias{text_case_when}
\title{Perform whole text replacements using a 'case-when'-expression approach}
\usage{
text_case_when(.data, ..., .default = NULL, .locations = cells_body())
}
\arguments{
\item{.data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{...}{A sequence of two-sided formulas. The left hand side (LHS)
determines which values match this case. The right hand side (RHS) provides
the replacement text (it must resolve to a value of the \code{character} class).
The LHS inputs must evaluate to logical vectors.}

\item{.default}{The replacement text to use when cell values aren't matched
by any of the LHS inputs. If \code{NULL}, the default, no replacement text will
be used.}

\item{.locations}{The cell or set of cells to be associated with the text
transformation. Only the \code{\link[=cells_body]{cells_body()}}, \code{\link[=cells_stub]{cells_stub()}},
\code{\link[=cells_column_labels]{cells_column_labels()}}, and \code{\link[=cells_row_groups]{cells_row_groups()}} helper functions can be
used here. We can enclose several of these calls within a \code{list()} if we
wish to make the transformation happen at different locations.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{text_case_when()} function provides a useful interface for a
case-by-case approach to replacing entire table cells. First off, you have to
make sure you're targeting the appropriate cells with the \code{.locations}
argument. Following that, you supply a sequence of two-sided formulas
matching of the general form: \verb{<logical_stmt> ~ <new_text>}. In the left hand
side (LHS) there should be a predicate statement that evaluates to a logical
vector of length one (i.e., either \code{TRUE} or \code{FALSE}). To refer to the values
undergoing transformation, you need to use the \code{x} variable.
}
\section{Examples}{


Use \code{\link{metro}} to create a \strong{gt} table. In the \code{connect_rer} column,
perform a count of pattern matches with \code{stringr::str_count()} and determine
which cells have 1, 2, or 3 matched patterns. For each of these cases,
provide descriptive replacement text. Here, we use a \code{.default} to replace
the non-matched cases with an empty string.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{metro |>
  dplyr::arrange(desc(passengers)) |>
  dplyr::select(name, lines, connect_rer) |>
  dplyr::slice_head(n = 10) |>
  gt() |>
  text_case_when(
    stringr::str_count(x, pattern = "[ABCDE]") == 1 ~ "One connection.",
    stringr::str_count(x, pattern = "[ABCDE]") == 2 ~ "Two connections.",
    stringr::str_count(x, pattern = "[ABCDE]") == 3 ~ "Three connections.",
    .default = "", .locations = cells_body(columns = connect_rer)
  ) |>
  cols_label(
    name = "Station",
    lines = "Lines Serviced",
    connect_rer = "RER Connections"
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_text_case_when_1.png" alt="This image of a table was generated from the first code example in the `text_case_when()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

4-2
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
Other text transforming functions: 
\code{\link{text_case_match}()},
\code{\link{text_replace}()},
\code{\link{text_transform}()}
}
\concept{text transforming functions}
