% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_style_by_grp.R
\name{tab_style_by_grp}
\alias{tab_style_by_grp}
\title{Add table styling to specific rows by group}
\usage{
tab_style_by_grp(gt_object, column, fn, ...)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{column}{The column using tidy variable name or a number indicating which column should have the styling affect it.}

\item{fn}{The name of a summarizing function (ie \code{max()}, \code{min()})}

\item{...}{Arguments passed to \code{tab_style(style = ...)}}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{tab_style_by_grp} function takes an existing \code{gt_tbl} object and
styling according to each group. Currently it support styling the \code{max()}/\code{min()}
for each group.
}
\section{Figures}{

\if{html}{\figure{grp-tab-style.png}{options: width=20\%}}
}

\section{Function ID}{

2-12
}

\examples{
library(gt)
df_in <- mtcars \%>\%
  dplyr::select(cyl:hp, mpg) \%>\%
  tibble::rownames_to_column() \%>\%
  dplyr::group_by(cyl) \%>\%
  dplyr::slice(1:4) \%>\%
  dplyr::ungroup()

test_tab <- df_in \%>\%
  gt(groupname_col = "cyl") \%>\%
  tab_style_by_grp(mpg, fn = max,
                   cell_fill(color = "red", alpha = 0.5))

}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{pad_fn}()}
}
\concept{Utilities}
