% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_df.R
\name{generate_df}
\alias{generate_df}
\title{Generate pseudorandom dataframes with specific parameters}
\usage{
generate_df(n = 10L, n_grps = 1L, mean = c(10), sd = mean/10, with_seed = NULL)
}
\arguments{
\item{n}{An integer indicating the number of rows per group, default to \code{10}}

\item{n_grps}{An integer indicating the number of rows per group, defaults to \code{1}}

\item{mean}{A number indicating the mean of the randomly generated values, must be a vector of equal length to the \code{n_grps}}

\item{sd}{A number indicating the standard deviation of the randomly generated values, must be a vector of equal length to the \code{n_grps}}

\item{with_seed}{A seed to make the randomization reproducible}
}
\value{
a tibble/dataframe
}
\description{
This function is a small utility to create a specific length dataframe
with a set number of groups, specific mean/sd per group. Note that the total length
of the dataframe will be \code{n} * \code{n_grps}.
}
\section{Function ID}{

2-19
}

\examples{
library(dplyr)
generate_df(
  100L,
  n_grps = 5,
  mean = seq(10, 50, length.out = 5)
) \%>\%
  group_by(grp) \%>\%
  summarise(
    mean = mean(values), # mean is approx mean
    sd = sd(values), # sd is approx sd
    n = n(), # each grp is of length n
    # showing that the sd default of mean/10 works
    `mean/sd` = round(mean / sd, 1)
  )
}
\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_highlight_cols}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_border}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_merge_stack_color}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
