% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tissue_site_detail.R
\name{get_tissue_site_detail}
\alias{get_tissue_site_detail}
\title{Get Tissue Site Detail}
\usage{
get_tissue_site_detail(page = 0, itemsPerPage = 250)
}
\arguments{
\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250).}
}
\value{
A tibble
}
\description{
Retrieve all tissue site detail information in the database

\href{https://gtexportal.org/api/v2/redoc#tag/Datasets-Endpoints/operation/get_tissue_site_detail_api_v2_dataset_tissueSiteDetail_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
  # returns a tibble with one row per tissue
  get_tissue_site_detail()

  # `eqtlSampleSummary` and `rnaSeqSampleSummary` are list columns
  bladder_site_details <- get_tissue_site_detail() |>
    dplyr::filter(tissueSiteDetailId == "Bladder")

  purrr::pluck(bladder_site_details, "eqtlSampleSummary", 1)

  purrr::pluck(bladder_site_details, "rnaSeqSampleSummary", 1)
}
}
\seealso{
Other Datasets Endpoints: 
\code{\link{get_annotation}()},
\code{\link{get_collapsed_gene_model_exon}()},
\code{\link{get_downloads_page_data}()},
\code{\link{get_file_list}()},
\code{\link{get_full_get_collapsed_gene_model_exon}()},
\code{\link{get_functional_annotation}()},
\code{\link{get_linkage_disequilibrium_by_variant_data}()},
\code{\link{get_linkage_disequilibrium_data}()},
\code{\link{get_sample_datasets_endpoints}()},
\code{\link{get_subject}()},
\code{\link{get_variant}()},
\code{\link{get_variant_by_location}()}
}
\concept{Datasets Endpoints}
