% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_gtfs.R
\name{filter_by_shape_id}
\alias{filter_by_shape_id}
\title{Filter GTFS data by shape ids}
\usage{
filter_by_shape_id(gtfs_data, shape_ids, remove_invalid = TRUE)
}
\arguments{
\item{gtfs_data}{A list of data.tables read using gtfs2gps::reag_gtfs().}

\item{shape_ids}{A vector of shape_ids belonging to the shapes of the
gtfs_data data. Note that shape_id might be loaded by gtfs2gps::read_gtfs()
as a string or a number, depending on the available values.}

\item{remove_invalid}{Remove all the invalid objects after subsetting the data?
The default value is TRUE.}
}
\value{
A filtered GTFS data.
}
\description{
Filter a GTFS data by its shape ids. It also removes the
unnecessary trips, stop_times, stops, and routes accordingly.
}
\examples{
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))

subset <- filter_by_shape_id(poa, "T2-1")
}
