% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_global_p.R
\name{add_global_p.tbl_regression}
\alias{add_global_p.tbl_regression}
\title{Adds the global p-value for categorical variables}
\usage{
\method{add_global_p}{tbl_regression}(
  x,
  include = x$table_body$variable[x$table_body$var_type \%in\% c("categorical",
    "interaction")],
  keep = FALSE,
  terms = NULL,
  ...
)
}
\arguments{
\item{x}{Object with class \code{tbl_regression} from the
\link{tbl_regression} function}

\item{include}{Variables to calculate global p-value for. Input may be a vector of
quoted or unquoted variable names. tidyselect and gtsummary select helper
functions are also accepted. Default is \code{NULL}, which adds global p-values
for all categorical and interaction terms.}

\item{keep}{Logical argument indicating whether to also retain the individual
p-values in the table output for each level of the categorical variable.
Default is \code{FALSE}}

\item{terms}{DEPRECATED.  Use \verb{include=} argument instead.}

\item{...}{Additional arguments to be passed to \link[car:Anova]{car::Anova}}
}
\value{
A \code{tbl_regression} object
}
\description{
This function uses \link[car:Anova]{car::Anova} with argument
\code{type = "III"} to calculate global p-values for categorical variables.
}
\section{Note}{

If a needed class of model is not supported by
\link[car:Anova]{car::Anova}, please create a
\href{https://github.com/ddsjoberg/gtsummary/issues}{GitHub Issue} to request support.
}

\section{Example Output}{

\if{html}{\figure{tbl_lm_global_ex1.png}{options: width=50\%}}
}

\examples{
tbl_lm_global_ex1 <-
  lm(marker ~ age + grade, trial) \%>\%
  tbl_regression() \%>\%
  add_global_p()
}
\seealso{
Other tbl_regression tools: 
\code{\link{add_nevent.tbl_regression}()},
\code{\link{add_q}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{combine_terms}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_header}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()},
\code{\link{tbl_stack}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
