% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variance_function.R
\name{var_pois}
\alias{var_pois}
\title{Variance estimator for a Poisson sampling design}
\usage{
var_pois(y, pik, w = rep(1, length(pik)))
}
\arguments{
\item{y}{A (sparse) numerical matrix of the variable(s) whose variance of their total
is to be estimated.}

\item{pik}{A numerical vector of first-order inclusion probabilities.}

\item{w}{An optional numerical vector of row weights (see Details).}
}
\value{
The estimated variances as a numerical vector of size the number of 
  columns of \code{y}.
}
\description{
\code{var_pois} estimates the variance of the estimator 
of a total for a Poisson sampling design.
}
\details{
\code{w} is a row weight used at the final summation step. It is useful
  when \code{var_pois} is used on the second stage of a two-stage sampling
  design applying the Rao (1975) formula.
}
\references{
Rao, J.N.K (1975), "Unbiased variance estimation for multistage designs",
  \emph{Sankhya}, C n°37
}
\author{
Martin Chevalier
}
