% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-variants.R
\name{genomic_contexts_tbl}
\alias{genomic_contexts_tbl}
\title{Creates a genomic contexts table.}
\usage{
genomic_contexts_tbl(
  variant_id = character(),
  gene_name = character(),
  chromosome_name = character(),
  chromosome_position = integer(),
  distance = integer(),
  is_mapped_gene = logical(),
  is_closest_gene = logical(),
  is_intergenic = logical(),
  is_upstream = logical(),
  is_downstream = logical(),
  source = character(),
  mapping_method = character()
)
}
\arguments{
\item{variant_id}{A character vector of variant identifiers.}

\item{gene_name}{A character vector of gene symbols according to
\href{https://www.genenames.org/}{HUGO Gene Nomenclature (HGNC)}.}

\item{chromosome_name}{A character vector of chromosome names.}

\item{chromosome_position}{An integer vector of chromosome positions.}

\item{distance}{An integer vector of genomic positions.}

\item{is_closest_gene}{A logical vector.}

\item{is_intergenic}{A logical vector.}

\item{is_upstream}{A logical vector.}

\item{is_downstream}{A logical vector.}

\item{source}{A character vector of gene mapping sources.}

\item{mapping_method}{A character vector of gene mapping methods.}
}
\value{
A \code{\link[tibble]{tibble}} whose columns are the named arguments
  to the function.
}
\description{
Creates a genomic contexts table.
}
\keyword{internal}
