% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.mean}
\alias{h2o.mean}
\alias{mean,H2OFrame-method}
\title{Mean of a column}
\usage{
h2o.mean(x, trim = 0, na.rm = FALSE, ...)

\S4method{mean}{H2OFrame}(x, trim = 0, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}

\item{trim}{The fraction (0 to 0.5) of observations to trim from each end of \code{x} before the mean is computed.}

\item{na.rm}{A logical value indicating whether \code{NA} or missing values should be stripped before the computation.}

\item{...}{Further arguments to be passed from or to other methods.}
}
\description{
Obtain the mean of a column of a parsed H2O data object.
}
\examples{
\dontrun{
localH2O <- h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(localH2O, path = prosPath)
mean(prostate.hex$AGE)
}
}
\seealso{
\code{\link[base]{mean}} for the base R implementation.
}

