% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.deepfeatures}
\alias{h2o.deepfeatures}
\title{Feature Generation via H2O Deep Learning or DeepWater Model}
\usage{
h2o.deepfeatures(object, data, layer)
}
\arguments{
\item{object}{An \linkS4class{H2OModel} object that represents the deep
learning model to be used for feature extraction.}

\item{data}{An H2OFrame object.}

\item{layer}{Index (for DeepLearning, integer) or Name (for DeepWater, String) of the hidden layer to extract}
}
\value{
Returns an H2OFrame object with as many features as the
        number of units in the hidden layer of the specified index.
}
\description{
Extract the non-linear feature from an H2O data set using an H2O deep learning
model.
}
\examples{
\donttest{
library(h2o)
h2o.init()
prostate_path = system.file("extdata", "prostate.csv", package = "h2o")
prostate = h2o.importFile(path = prostate_path)
prostate_dl = h2o.deeplearning(x = 3:9, y = 2, training_frame = prostate,
                               hidden = c(100, 200), epochs = 5)
prostate_deepfeatures_layer1 = h2o.deepfeatures(prostate_dl, prostate, layer = 1)
prostate_deepfeatures_layer2 = h2o.deepfeatures(prostate_dl, prostate, layer = 2)
head(prostate_deepfeatures_layer1)
head(prostate_deepfeatures_layer2)

#if (h2o.deepwater.available()) {
#  prostate_dl = h2o.deepwater(x = 3:9, y = 2, backend="mxnet", training_frame = prostate,
#                              hidden = c(100, 200), epochs = 5)
#  prostate_deepfeatures_layer1 =
#    h2o.deepfeatures(prostate_dl, prostate, layer = "fc1_w")
#  prostate_deepfeatures_layer2 =
#    h2o.deepfeatures(prostate_dl, prostate, layer = "fc2_w")
#  head(prostate_deepfeatures_layer1)
#  head(prostate_deepfeatures_layer2)
#}
}
}
\seealso{
\code{\link{h2o.deeplearning}} for making H2O Deep Learning models.

\code{\link{h2o.deepwater}} for making H2O DeepWater models.
}
