% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame.R
\name{dimnames.H2OFrame}
\alias{dimnames.H2OFrame}
\title{Column names of an H2OFrame}
\usage{
\method{dimnames}{H2OFrame}(x)
}
\arguments{
\item{x}{An H2OFrame}
}
\description{
Set column names of an H2O Frame
}
\examples{
\dontrun{
h2o.init()
n <- 2000
#  Generate variables V1, ... V10
X <- matrix(rnorm(10 * n), n, 10)
#  y = +1 if sum_i x_{ij}^2 > chisq median on 10 df
y <- rep(-1, n)
y[apply(X*X, 1, sum) > qchisq(.5, 10)] <- 1
#  Assign names to the columns of X:
dimnames(X)[[2]] <- c("V1", "V2", "V3", "V4", "V5", "V6", "V7", "V8", "V9", "V10")
}
}
