% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{h2o.confusionMatrix}
\alias{h2o.confusionMatrix}
\alias{h2o.confusionMatrix,H2OModel-method}
\alias{h2o.confusionMatrix,H2OModelMetrics-method}
\title{Access H2O Confusion Matrices}
\usage{
h2o.confusionMatrix(object, ...)

\S4method{h2o.confusionMatrix}{H2OModel}(object, newdata, valid = FALSE, ...)

\S4method{h2o.confusionMatrix}{H2OModelMetrics}(object, thresholds = NULL, metrics = NULL)
}
\arguments{
\item{object}{Either an \linkS4class{H2OModel} object or an
\linkS4class{H2OModelMetrics} object.}

\item{...}{Extra arguments for extracting train or valid confusion matrices.}

\item{newdata}{An H2OFrame object that can be scored on.
Requires a valid response column.}

\item{valid}{Retrieve the validation metric.}

\item{thresholds}{(Optional) A value or a list of valid values between 0.0 and 1.0.
This value is only used in the case of
\linkS4class{H2OBinomialMetrics} objects.}

\item{metrics}{(Optional) A metric or a list of valid metrics ("min_per_class_accuracy", "absolute_mcc", "tnr", "fnr", "fpr", "tpr", "precision", "accuracy", "f0point5", "f2", "f1").
This value is only used in the case of
\linkS4class{H2OBinomialMetrics} objects.}
}
\value{
Calling this function on \linkS4class{H2OModel} objects returns a
        confusion matrix corresponding to the \code{\link{predict}} function.
        If used on an \linkS4class{H2OBinomialMetrics} object, returns a list
        of matrices corresponding to the number of thresholds specified.
}
\description{
Retrieve either a single or many confusion matrices from H2O objects.
}
\details{
The \linkS4class{H2OModelMetrics} version of this function will only take
\linkS4class{H2OBinomialMetrics} or \linkS4class{H2OMultinomialMetrics}
objects. If no threshold is specified, all possible thresholds are selected.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.uploadFile(prostate_path)
prostate[,2] <- as.factor(prostate[,2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = prostate, distribution = "bernoulli")
h2o.confusionMatrix(model, prostate)
# Generating a ModelMetrics object
perf <- h2o.performance(model, prostate)
h2o.confusionMatrix(perf)
}
}
\seealso{
\code{\link{predict}} for generating prediction frames,
         \code{\link{h2o.performance}} for creating
         \linkS4class{H2OModelMetrics}.
}
