% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{h2o.save_frame}
\alias{h2o.save_frame}
\title{Store frame data in H2O's native format.}
\usage{
h2o.save_frame(x, dir, force = TRUE)
}
\arguments{
\item{x}{An H2OFrame object}

\item{dir}{a filesystem location where to write frame data (hdfs, nfs)}

\item{force}{\code{logical}. overwrite already existing files (defaults to true)}
}
\description{
Store frame data in H2O's native format.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

prostate_path = system.file("extdata", "prostate.csv", package = "h2o")
prostate = h2o.importFile(path = prostate_path)
h2o.save_frame(prostate, "/tmp/prostate")
}
}
